function xprime=flnlesc_steep_derivatives(t,x)

global A B InvWc x0 xs t0 t1 K;
global usave tsave 

x1=x(1);
x2=x(2);

% perform state transition between x and z
z0(1)=x0(1);
z0(2)=-x0(1)+x0(2);
z0=z0.';

zs(1)=xs(1);
zs(2)=-xs(1)+xs(2);
zs=zs.';

% feedback linearzation controlller
uf=-x1+x2-x1*x2-2*x1-3*(-x1+x2);
% state transition controller
ut=-(B.')*eatt(t1-t)*InvWc*(eat(t1-t0)*z0-zs); 

u=uf+ut;

% Plant dynamics
xprime(1)=-x1+x2;
xprime(2)=x1*x2+u;
% with input disturbance 0.8*rand(1)
%xprime(2)=x1*x2+(u+0*rand(1)); 

xprime=xprime.';
tsave = [tsave;t];
usave = [usave;u];